/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-05-06
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "GraphicSheetMenu.h"
#include "AxisWindow.h"
#include "GraphContents.h"
#include "TextEdit.h"

namespace SciFigs {

GraphicSheetMenu::GraphicSheetMenu(QWidget* parent, Qt::WindowFlags f) :
    QWidget(parent, f), _sheet(this)
{
  TRACE;
  _sheet.setObjectName("sheet");
  _childLayout=new QVBoxLayout(this);
  _childLayout->setContentsMargins(0, 0, 0, 0);
  _childLayout->setSpacing(0);
#if !defined(Q_OS_DARWIN) && !defined(UBUNTU_UNITY)
  _menuBar=new QMenuBar(this);
  _childLayout->addWidget(_menuBar);
#endif
  addActions();
  _childLayout->addWidget(&_sheet);
  setGeometry(5, 80, 700, 500);
}

QMenu * GraphicSheetMenu::addMenu(QString title)
{
  TRACE;
  QMenu * m=new QMenu(this);
  m->setTitle(title);
#if !defined(Q_OS_DARWIN) && !defined(UBUNTU_UNITY)
  _menuBar->addMenu(m);
#endif
  _sheet.addMenu(m);
  return m;
}

void GraphicSheetMenu::addActions()
{
  TRACE;
  menuFile=addMenu(tr("&File"));
  _sheet.addFileActions(menuFile, 0);

  menuEdit=addMenu(tr("&Edit"));
  _sheet.addEditActions(menuEdit, 0);

  menuInsert=addMenu(tr("&Insert"));
  _sheet.addInsertActions(menuInsert, 0);

  menuFormat=addMenu(tr("&Format"));
  _sheet.addFormatActions(menuFormat);
}

void GraphicSheetMenu::removeObject(GraphicObject * o)
{
  TRACE;
  _sheet.removeObject(o, true);
}

} // namespace SciFigs
