/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-03-31
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "GraphicObjectGeometryProperties.h"

namespace SciFigs {

/*!
  \class GraphicObjectGeometryProperties GraphicObjectGeometryProperties.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
GraphicObjectGeometryProperties::GraphicObjectGeometryProperties(QWidget * parent)
    : PropertyWidget(parent)
{
  setupUi(this);

  // Create properties
  addProperty(X, xEdit, xLabel);
  addProperty(Y, yEdit, yLabel);
  addProperty(MoveSelection, moveSelectionEdit, moveSelectionLabel);
  addProperty(Anchor, anchorEdit, anchorLabel);
  addProperty(Width, widthEdit, widthLabel);
  addProperty(Height, heightEdit, heightLabel);
  addProperty(ConstantWidthHeightRatio, constantWidthHeightRatio, constantWidthHeightRatio);
  addProperty(WidthHeightRatio);
}

int GraphicObjectGeometryProperties::anchor2item(GraphicObject::PositionAnchor pa)
{
  TRACE;
  switch (pa) {
  case GraphicObject::TopCenter:
    return 1;
  case GraphicObject::TopRight:
    return 2;
  case GraphicObject::CenterLeft:
    return 3;
  case GraphicObject::Center:
    return 4;
  case GraphicObject::CenterRight:
    return 5;
  case GraphicObject::BottomLeft:
    return 6;
  case GraphicObject::BottomCenter:
    return 7;
  case GraphicObject::BottomRight:
    return 8;
  default:
    return 0;
  }
}

GraphicObject::PositionAnchor GraphicObjectGeometryProperties::item2anchor(int index)
{
  switch (index) {
  case 1:
    return GraphicObject::TopCenter;
  case 2:
    return GraphicObject::TopRight;
  case 3:
    return GraphicObject::CenterLeft;
  case 4:
    return GraphicObject::Center;
  case 5:
    return GraphicObject::CenterRight;
  case 6:
    return GraphicObject::BottomLeft;
  case 7:
    return GraphicObject::BottomCenter;
  case 8:
    return GraphicObject::BottomRight;
  default:
    return GraphicObject::TopLeft;
  }
}

} // namespace SciFigs
