/***************************************************************************
**
**  This file is part of SciFigs.
**
**  SciFigs is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  SciFigs is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-02-17
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ExternalPlotLine2D.h"

namespace SciFigs {

  /*!
    \class ExternalPlotLine2D ExternalPlotLine2D.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  ExternalPlotLine2D::ExternalPlotLine2D(const ExternalPlotLine2D& o)
    : AbstractLine(o)
  {
    TRACE;
    _curve=o._curve;
  }

  AbstractLine * ExternalPlotLine2D::clone() const
  {
    TRACE;
    return new ExternalPlotLine2D(*this);
  }

  bool ExternalPlotLine2D::canCopy(const AbstractLine& o) const
  {
    TRACE;
    return dynamic_cast<const ExternalPlotLine2D *>(&o);
  }

  void ExternalPlotLine2D::operator=(const AbstractLine& o)
  {
    TRACE;
    const ExternalPlotLine2D * co=static_cast<const ExternalPlotLine2D *>(&o);
    ASSERT(co);
    _curve=co->_curve;
    AbstractLine::operator=(o);
  }

  /*!
    Description still missing
  */
  void ExternalPlotLine2D::setCurve(Curve<Point2D> * curve)
  {
    TRACE;
    _curve=curve;
  }

  /*!
    Description still missing
  */
  void ExternalPlotLine2D::setCurve(Curve<Point2D> * curve, const Pen& pen, const Symbol& sym)
  {
    TRACE;
    setCurve(curve);
    setPen(pen);
    setSymbol(sym);
    setSelected(false);
  }

} // namespace SciFigs

