/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-03-26
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COLORMAPLAYER_H
#define COLORMAPLAYER_H

#include "GraphContentsLayer.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

class SCIFIGS_EXPORT ColorMapLayer : public GraphContentsLayer
{
  Q_OBJECT
  Q_PROPERTY(QString axisType READ axisTypeString WRITE setAxisType SCRIPTABLE true)
public:
  ColorMapLayer(AxisWindow * parent=nullptr);

  virtual const QString& xml_tagName() const {return xmlColorMapLayerTag;}
  static const QString xmlColorMapLayerTag;

  void setAxisType(AxisType a);
  AxisType axisType() const {return _axisType;}
  QString axisTypeString() const {return _axisType==XAxis ? "X":"Y";}
  void setAxisType(QString t) {if(t.contains("X")) setAxisType(XAxis); else setAxisType(YAxis);}

  const ColorMap& colorMap() const {return _colorMap;}
  void setColorMap(const ColorMap& colorMap) {_colorMap=colorMap;}

  virtual Rect boundingRect() const;
protected:
  virtual void paintData(const LayerPainterRequest& lp, QPainter& p, double dotpercm) const;
  virtual QString coordinateTipInfo(const Point2D& p, const Point2D &) const;
private:
  static inline void paintX(double min, double max, double w, double h, const QColor& col,
                            const GraphContentsOptions& gc, QPainter& p);
  static inline void paintY(double min, double max, double w, double h, const QColor& col,
                            const GraphContentsOptions& gc, QPainter& p);

  AxisType _axisType;
  ColorMap _colorMap;
};

} // namespace SciFigs

#endif // COLORMAPLAYER_H
