/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-03-28
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "AxisFormatProperties.h"

namespace SciFigs {

/*!
  \class AxisFormatProperties AxisFormatProperties.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
AxisFormatProperties::AxisFormatProperties(QWidget * parent)
    : PropertyWidget(parent)
{
  TRACE;
  setupUi(this);

  addProperty(Title, titleEdit, titleLabel);
  addProperty(Font, titleEdit, fontEdit);
  addProperty(Orientation, orientationEdit, orientationLabel);
  addProperty(LineWeight, lineWeightEdit, lineWeightLabel);
  addProperty(TickSize, tickSizeEdit, tickSizeLabel);
  addProperty(NumberType, numberTypeEdit);
  addProperty(NumberPrecision, precisionEdit, precisionLabel);
  addProperty(Autoprecision, automaticPrecision);
  addProperty(UnitFactor, unitFactorEdit, unitFactorLabel);
}

PropertyValue::WidgetType AxisFormatProperties::determineCustomWidgetType(int pid, QWidget *, QWidget * )
{
  TRACE;
  if(pid==Font) {
    return PropertyValue::Custom0;
  } else {
    return PropertyValue::Unknown;
  }
}

bool AxisFormatProperties::connectCustomWidget(PropertyValue & p)
{
  TRACE;
  if(p.widgetType()==PropertyValue::Custom0) {
    return true;
  } else {
    return false;
  }
}

bool AxisFormatProperties::setCustomWidget(PropertyValue & p)
{
  TRACE;
  if(p.widgetType()==PropertyValue::Custom0) {
    QFont f;
    if(f.fromString(p.value().toString()) ) {
      static_cast<QTextEdit *>(p.widget())->setFont(f);
    }
    return true;
  } else {
    return false;
  }
}

QVariant AxisFormatProperties::customWidgetValue(PropertyValue & p)
{
  TRACE;
  if(p.widgetType()==PropertyValue::Custom0) {
    return static_cast<QTextEdit *>(p.widget())->font().toString();
  } else {
    return QVariant();
  }
}

void AxisFormatProperties::on_automaticPrecision_toggled(bool b)
{
  TRACE;
  precisionEdit->setEnabled(!b);
  precisionLabel->setEnabled(!b);
}

void AxisFormatProperties::on_fontEdit_clicked()
{
  TRACE;
  bool ok;
  QFont f=QFontDialog::getFont(&ok, titleEdit->font(), this);
  if(ok) {
    titleEdit->setFont(f);
    titleEdit->blockSignals(true);
    titleEdit->setPlainText(titleEdit->toPlainText());
    titleEdit->blockSignals(false);
    propertyValue(Font)->touched();
  }
}

int AxisFormatProperties::numberType2item(char nt)
{
  TRACE;
  switch (nt) {
  case 'e':
    return 1;
  default:
    return 0;
  }
}

char AxisFormatProperties::item2numberType(int index)
{
  TRACE;
  switch (index) {
  case 1:
    return 'e';
  default:
    return 'f';
  }
}

int AxisFormatProperties::orientation2item(Axis::Orientation o)
{
  TRACE;
  switch (o) {
  case Axis::South:
    return 1;
  case Axis::East:
    return 2;
  case Axis::West:
    return 3;
  default:
    return 0;
  }

}

Axis::Orientation AxisFormatProperties::item2orientation(int index)
{
  TRACE;
  switch (index) {
  case 1:
    return Axis::South;
  case 2:
    return Axis::East;
  case 3:
    return Axis::West;
  default:
    return Axis::North;
  }
}

} // namespace SciFigs
