/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-02-06
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "AutoAdjustScaleProperties.h"
#include "AutoAdjustScale.h"

namespace SciFigs {

  /*!
    \class AutoAdjustScaleProperties AutoAdjustScaleProperties.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  AutoAdjustScaleProperties::AutoAdjustScaleProperties(QWidget * parent)
      : PropertyWidget(parent)
  {
    TRACE;
    setupUi(this);

    addProperty(AutoAdjust, autoAdjustEdit);
    addProperty(LinearScale, linearScale);
    addProperty(LogScale, logScale);
    addProperty(ForceMinValue, forceMinValue);
    addProperty(ForceMaxValue, forceMaxValue);
    addProperty(ForceRatio, forceRatio);
    addProperty(Symetric, symetric);
    addProperty(MinValue, minValueEdit);
    addProperty(MaxValue, maxValueEdit);
    addProperty(Ratio, ratioEdit);
  }

  void AutoAdjustScaleProperties::on_linearScale_toggled(bool c)
  {
    symetric->setEnabled(c);
  }

  void AutoAdjustScaleProperties::on_forceMinValue_toggled(bool c)
  {
    minValueEdit->setEnabled(c);
  }

  void AutoAdjustScaleProperties::on_forceMaxValue_toggled(bool c)
  {
    maxValueEdit->setEnabled(c);
  }

  void AutoAdjustScaleProperties::on_forceRatio_toggled(bool c)
  {
    ratioEdit->setEnabled(c);
  }

} // namespace SciFigs
