/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-10-18
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "AutoAdjustScale.h"
#include "AutoAdjustScaleProperties.h"

namespace SciFigs {

  /*!
    \class AutoAdjustScale AutoAdjustScale.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  AutoAdjustScale::AutoAdjustScale()
  {
    TRACE;
    _autoAdjust=true;
    _forceMinimumValue=false;
    _forceMaximumValue=false;
    _forceRatio=true;
    _symetric=false;
    _scale=SamplingParameters::Linear;
    _minimumValue=0.0;
    _maximumValue=0.0;
    _ratio=1000.0;
  }

  /*!
    Description of constructor still missing
  */
  AutoAdjustScale::AutoAdjustScale(const AutoAdjustScale& o)
  {
    TRACE;
    _autoAdjust=o._autoAdjust;
    _forceMinimumValue=o._forceMinimumValue;
    _forceMaximumValue=o._forceMaximumValue;
    _forceRatio=o._forceRatio;
    _symetric=o._symetric;
    _scale=o._scale;
    _minimumValue=o._minimumValue;
    _maximumValue=o._maximumValue;
    _ratio=o._ratio;
  }

  void AutoAdjustScale::properties(PropertyWidget * w) const
  {
    w->setValue(AutoAdjustScaleProperties::AutoAdjust, autoAdjust());
    w->setValue(AutoAdjustScaleProperties::LinearScale, scale()==SamplingParameters::Linear);
    w->setValue(AutoAdjustScaleProperties::LogScale, scale()==SamplingParameters::Log);
    w->setValue(AutoAdjustScaleProperties::ForceMinValue, forceMinimumValue());
    w->setValue(AutoAdjustScaleProperties::ForceMaxValue, forceMaximumValue());
    w->setValue(AutoAdjustScaleProperties::ForceRatio, forceRatio());
    w->setValue(AutoAdjustScaleProperties::Symetric, symetric());
    w->setValue(AutoAdjustScaleProperties::MinValue, minimumValue());
    w->setValue(AutoAdjustScaleProperties::MaxValue, maximumValue());
    w->setValue(AutoAdjustScaleProperties::Ratio, ratio());
  }

  void AutoAdjustScale::setProperty(int pid, QVariant val)
  {
    switch(pid) {
    case AutoAdjustScaleProperties::AutoAdjust:
      setAutoAdjust(val.toBool());
      break;
    case AutoAdjustScaleProperties::LinearScale:
      setScale(val.toBool() ? SamplingParameters::Linear : SamplingParameters::Log);
      break;
    case AutoAdjustScaleProperties::LogScale:
      setScale(val.toBool() ? SamplingParameters::Log : SamplingParameters::Linear);
      break;
    case AutoAdjustScaleProperties::ForceMinValue:
      setForceMinimumValue(val.toBool());
      break;
    case AutoAdjustScaleProperties::ForceMaxValue:
      setForceMaximumValue(val.toBool());
      break;
    case AutoAdjustScaleProperties::ForceRatio:
      setForceRatio(val.toBool());
      break;
    case AutoAdjustScaleProperties::Symetric:
      setSymetric(val.toBool());
      break;
    case AutoAdjustScaleProperties::MinValue:
      setMinimumValue(val.toDouble());
      break;
    case AutoAdjustScaleProperties::MaxValue:
      setMaximumValue(val.toDouble());
      break;
    case AutoAdjustScaleProperties::Ratio:
      setRatio(val.toDouble());
      break;
    }
  }

} // namespace SciFigs

