/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  QGpGuiWave is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiWave is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-09-21
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MODALLINE_H
#define MODALLINE_H

#include <SciFigs.h>
#include <QGpCoreWave.h>
#include "QGpGuiWaveDLLExport.h"

namespace QGpGuiWave {

class QGPGUIWAVE_EXPORT ModalLine : public AbstractLine
{
  TRANSLATIONS("ModalLine")
public:
  ModalLine() {}
  ModalLine(const ModalLine& o);

  AbstractLine * clone() const;
  void operator=(const AbstractLine& o);
  bool canCopy(const AbstractLine& o) const;

  const QString& xml_tagName() const {return xmlModalLineTag;}
  static const QString xmlModalLineTag;

  int count() const {return _curve.count();}
  void clear() {_curve.clear();}
  void append() {_curve.append(FactoryPoint());}
  void insert(int index) {_curve.insert(index, FactoryPoint());}
  void removeLast() {_curve.remove(_curve.count()-1);}
  bool isValid(int index) const {return _curve.isValid(index);}
  void setValid(int index, bool v) {_curve.setValid(index, v);}
  void checkSort() {_curve.checkSort();}
  bool isSorted() const {return _curve.isSorted();}
  void indexRange(double xMin, double xMax, int& indexMin, int& indexMax) const {
    _curve.indexRange(xMin, xMax, indexMin, indexMax);
  }
  Point point(int index, const CurvePointOptions *) const;
  void setX(int index, double v) {_curve.setX(index, v);}
  void setY(int index, double v, const CurvePointOptions *) {_curve.constXAt(index).setMean(v);}
  void setZ(int index, double v, const CurvePointOptions *) {_curve.constXAt(index).setStddev(v);}

  const ModalCurve& curve() const {return _curve;}
  ModalCurve& curve() {return _curve;}
  void setCurve(const ModalCurve& curve) {_curve=curve;}
protected:
  ModalCurve _curve;
};

} // namespace QGpGuiWave

#endif // MODALLINE_H
