/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  QGpGuiWave is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiWave is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-09-27
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MODALCURVEBROWSER_H
#define MODALCURVEBROWSER_H

#include <QGpGuiMath.h>

#include "QGpGuiWaveDLLExport.h"
#include "ModalLine.h"
#include "ModeDelegate.h"

namespace QGpGuiWave {

  class QGPGUIWAVE_EXPORT ModalCurveBrowser : public CurveBrowser
  {
    Q_OBJECT
  public:
    ModalCurveBrowser(QWidget * parent=nullptr);
    ~ModalCurveBrowser();

    void setProxy(ModalProxy * proxy);
    void initLayer(LineLayer * curveLayer);

    void setModeType(Mode::Type t) {_type=t;}

    ModalLine * addCurve(const ModalCurve& curve);
    void addCurves(const QList<ModalCurve>& curves);
    QList<ModalCurve> curves() const;
  protected:
    virtual CurvePropertiesWidget * createProperties();
  private:
    Mode::Type _type;
  };

} // namespace QGpGuiWave

#endif // MODALCURVEBROWSER_H
