/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  QGpGuiWave is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiWave is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-12
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include <SciFigs.h>

#include "DispersionLimitLayer.h"

namespace QGpGuiWave {

/*!
  \class DispersionLimitLayer DispersionLimitLayer.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
DispersionLimitLayer::DispersionLimitLayer(AxisWindow * parent)
    : LineLayer(parent)
{
  TRACE;
  PlotLine * l=new PlotLine;
  l->setPen(Pen(Qt::black, 0.3, Pen::SolidLine));
  l->setSymbol(Symbol());
  setReferenceLine(l);
}

/*!
  Description of destructor still missing
*/
DispersionLimitLayer::~DispersionLimitLayer()
{
  TRACE;
}

/*!
*/
Curve<Point>& DispersionLimitLayer::curve(int index)
{
  TRACE;
  return static_cast<PlotLine *>(line(index))->curve();
}

void DispersionLimitLayer::setFrequencySampling(const SamplingParameters& fparam)
{
  TRACE;
  _freqSamp=fparam;
  updateFrequencySampling();
}

void DispersionLimitLayer::updateFrequencySampling()
{
  TRACE;
  if(_freqSamp.isValid()) {
    Point fcurve;
    for(int ic=count()-1; ic>=0; ic--) {
      Curve<Point>& c=curve(ic);
      c.clear();
      for(int i=0; i<_freqSamp.count(); i++) {
        fcurve.setX(_freqSamp.value(i));
        c.append(fcurve);
      }
    }
  }
}

void DispersionLimitLayer::setConstantWaveNumber(int curveIndex, double k)
{
  TRACE;
  LayerLocker ll(this);
  Curve<Point>& c=curve(curveIndex);
  double invWavelength=k/(2*M_PI);
  for(int i=0; i<c.count(); i++) {
    c.setY(i, invWavelength/c.x(i));
  }
  deepUpdate();
}

void DispersionLimitLayer::setConstantWaveLength(int curveIndex, double lambda)
{
  TRACE;
  LayerLocker ll(this);
  Curve<Point>& c=curve(curveIndex);
  for(int i=0; i<c.count(); i++) {
    c.setY(i, 1.0/(c.x(i)*lambda));
  }
  deepUpdate();
}

void DispersionLimitLayer::addArrayLimits()
{
  TRACE;
  addLine();
  addLine(Pen(Qt::black, 0.3, Pen::DotLine), Symbol());
  addLine(Pen(Qt::black, 0.3, Pen::DotLine), Symbol());
  addLine(Pen(Qt::black, 0.3, Pen::DashLine), Symbol());
}

void DispersionLimitLayer::setArrayKmin(double k)
{
  TRACE;
  setConstantWaveNumber(0, 0.5*k);
  setConstantWaveNumber(1, k);
}

void DispersionLimitLayer::setArrayKmax(double k)
{
  TRACE;
  setConstantWaveNumber(2, 0.5*k);
  setConstantWaveNumber(3, k);
}

void DispersionLimitLayer::setLambdaLegend(const Legend& l)
{
  TRACE;
  _lambdaLegend=l;
  int n=_lambdaLegend.count();
  clear();
  for(int i=0; i<n; i++) {
    addLine(Pen(_lambdaLegend.pen(i)), _lambdaLegend.symbol(i));
  }
  updateFrequencySampling();
  updateArraySize();
}

void DispersionLimitLayer::setArraySize(double s)
{
  TRACE;
  _arraySize=s;
  updateArraySize();
}

void DispersionLimitLayer::updateArraySize()
{
  TRACE;
  int n=count();
  for(int i=0; i<n; i++) {
    setConstantWaveLength(i, _arraySize*_lambdaLegend.text(i).toDouble());
  }
}

} // namespace QGpGuiWave
