/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-09-13
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef WIDGETRECT_H
#define WIDGETRECT_H

#include <QtGui>
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
#include <QtWidgets>
#endif

#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

  class QGPGUITOOLS_EXPORT WidgetRect
  {
  public:
    WidgetRect() {_valid=false; _lock=1;}
    ~WidgetRect() {}

    void saveRect(const QWidget * w, QString name=QString()) const;
  protected:
    void record(QWidget * w);
  private:
    QRect _rect;
    int _lock;
    bool _valid;
  };

} // namespace QGpGuiTools

#endif // WIDGETRECT_H

