/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  QGpGuiTools is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiTools is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-05-21
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "TableView.h"

namespace QGpGuiTools {

  /*!
    \class TableView TableView.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  TableView::TableView(QWidget * parent)
    : QTableView(parent)
  {
    TRACE;
    setSelectionBehavior(QAbstractItemView::SelectRows);
    setSelectionMode(QAbstractItemView::ExtendedSelection);
    setEditTriggers(QAbstractItemView::AllEditTriggers);
  }

  /*!
    Description of destructor still missing
  */
  TableView::~TableView()
  {
    TRACE;
  }

  void TableView::setItemDelegate(ItemDelegate * d)
  {
    TRACE;
    connect(d, SIGNAL(dataChanged(const QModelIndex&, StringDiff)),
            this, SLOT(changeAllRows(const QModelIndex&, StringDiff)));
    QTableView::setItemDelegate(d);
  }

  void TableView::changeAllRows(const QModelIndex& index, StringDiff string)
  {
    TRACE;
    QAbstractItemModel * m=model();
    QModelIndexList list=selectionModel()->selectedRows();
    if(list.count()>1) {
      QVariant val=m->data(index);
      QModelIndex otherRowsIndex;
      if(string.isValid()) {
        foreach(otherRowsIndex, list) {
          if(otherRowsIndex.row()!=index.row()) {
            QModelIndex commitIndex=m->index(otherRowsIndex.row(), index.column());
            m->setData(commitIndex, string.patch(m->data(commitIndex).toString()));
          }
        }
      } else {
        foreach(otherRowsIndex, list) {
          if(otherRowsIndex.row()!=index.row()) {
            m->setData(m->index(otherRowsIndex.row(), index.column()), val);
          }
        }
      }
    }
    emit allDataChanged();
  }

  void TableView::setBackgroundMessage(const QString& msg)
  {
    TRACE;
    _backgroundMessage=msg;
    if(_backgroundMessage.isEmpty()) {
      viewport()->removeEventFilter(this);
    } else {
      viewport()->installEventFilter(this);
    }
  }

  bool TableView::eventFilter(QObject * o, QEvent * e)
  {
    TRACE;
    if(e->type()==QEvent::Paint &&
       o==static_cast<QObject *>(viewport()) &&
       !_backgroundMessage.isEmpty() &&
       (model()->rowCount()==0 || model()->columnCount()==0)) {
      QPainter p(viewport());
      p.setPen(palette().brush(QPalette::Dark).color());
      p.drawText(0, 0, width(), height(), Qt::AlignCenter | Qt::AlignVCenter,
                 _backgroundMessage);
    }
    return QTableView::eventFilter(o, e);
  }

} // namespace QGpGuiTools

