/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-04-28
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SETTINGS_H
#define SETTINGS_H

#include <QtGui>
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
#include <QtWidgets>
#endif

#include <QGpCoreTools.h>

#include "QGpGuiToolsDLLExport.h"

class QPrinter;

namespace QGpGuiTools {

  class PrintRange;
  class TableView;

  class QGPGUITOOLS_EXPORT Settings
  {
  public:
    static QString getPath(const QString& filter);
    static void setPath(const QString& filter, QDir dirPath);

    static QStringList getDirHistory(const QString &caption);
    static void setDirHistory(const QString &caption, const QDir &newPath);

    static QStringList getHistory(const QString &name);
    static void setHistory(const QString &name, const QString &newString, int maxCount=20);
    static void removeHistory(const QString &name, const QString &string);

    static QStringList getHistory(QSettings &reg, const QString &name);
    static void setHistory(QSettings &reg, const QString &name, const QString &newString, int maxCount=20);
    static void removeHistory(QSettings &reg, const QString &name, const QString &string);

    static QString getFilter(const QString& name);
    static void setFilter(const QString& name, const QString& filter);

    static void getRect(QWidget * w, QString name=QString());
    static void setRect(const QWidget * w, QString name=QString());

    static void getSize(QWidget * w, QString name=QString());
    static void setSize(const QWidget * w, QString name=QString());

    static void setActiveTab(const QTabWidget * w, QString name);
    static void activeTab(QTabWidget * w, QString name);

    static void setSplitter(const QSplitter * w, QString name);
    static void splitter(QSplitter * w, QString name);

    static void setColumnWidth(const TableView * w, QString name);
    static void columnWidth(TableView * w, QString name);

    static void setColumnWidth(const QTreeView * w, QString name);
    static void columnWidth(QTreeView * w, QString name);

    static void setWidget(const QWidget *d, QString name=QString(), bool rect=true);
    static void getWidget(QWidget * d, QString name=QString(), bool rect=true);

    static QString getText(QWidget * parent, const QString &caption,
                           const QString &label, QLineEdit::EchoMode mode=QLineEdit::Normal,
                           const QString &text=QString(), bool * ok=nullptr);

    static bool printSetup(QPrinter * p);
  private:
    static void getWidget(QSettings &reg, const QObjectList &list);
    static void setWidget(QSettings &reg, const QObjectList &list);
  };

} // namespace QGpGuiTools

#endif // SETTINGS_H
