/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-03-31
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "PropertyTab.h"
#include "PropertyWidget.h"
#include "PropertyItem.h"

namespace QGpGuiTools {

  uint PropertyTab::_lastUniqueId=1;
  uint PropertyTab::invalidId=0;

  uint PropertyTab::uniqueId()
  {
    return _lastUniqueId++;
  }

  /*!
    \class PropertyTab PropertyTab.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  PropertyTab::PropertyTab()
  {
    _currentItem=nullptr;
    _widget=nullptr;
  }

  /*!
    Description of destructor still missing
  */
  PropertyTab::~PropertyTab()
  {
    delete _widget;
  }

  void PropertyTab::setWidget(PropertyWidget * w)
  {
    _widget=w;
    connect(w, SIGNAL(setProperty(int, QVariant)), this, SLOT(setProperty(int, QVariant)));
    connect(w, SIGNAL(refreshValues()), this, SLOT(setValues()));
  }

  void PropertyTab::setProperty(int id, QVariant val)
  {
    int wid=_widget->id();
    for(QSet<PropertyItem *>::iterator it=_references.begin();it!=_references.end();it++) {
      (*it)->setProperty(wid, id, val);
    }
  }

  bool PropertyTab::contains(PropertyItem * item)
  {
    return _references.contains(item);
  }

  void PropertyTab::addReference(PropertyItem * item)
  {
    QSet<PropertyItem *>::iterator it=_references.find(item);
    if(it!=_references.end()) {
      if(item==_currentItem) return;
      _currentItem=item;
    } else {
      _references.insert(item);
      _currentItem=item;
    }
  }

  void PropertyTab::removeReference(PropertyItem * item)
  {
    QSet<PropertyItem *>::iterator it=_references.find(item);
    if(it!=_references.end()) {
      _references.erase(it);
      if(_currentItem==item) {
        if(_references.isEmpty()) {
          _currentItem=0;
          return;
        } else {
          _currentItem=*_references.begin();
        }
      }
    }
  }

  /*!
    Set widget controls from object current values.
  */
  void PropertyTab::setValues()
  {
    _widget->reset();
    for(QSet<PropertyItem *>::iterator it=_references.begin();it!=_references.end();it++) {
      if(*it!=_currentItem) {
        (*it)->properties(_widget);
      }
    }
    if(_currentItem) {
      _currentItem->properties(_widget); // Set this one first to view its property values
    }
    _widget->setWidgets();
  }

} // namespace QGpGuiTools
