/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-06-23
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MULTIDOCUMENTTABBAR_H
#define MULTIDOCUMENTTABBAR_H

#include <QtGui>
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
#include <QtWidgets>
#endif

#include <QGpCoreTools.h>

#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

  class MultiDocumentTabWidget;

  class QGPGUITOOLS_EXPORT MultiDocumentTabBar : public QTabBar
  {
    Q_OBJECT
  public:
    MultiDocumentTabBar(QWidget * parent=nullptr);
    ~MultiDocumentTabBar();
  private slots:
    void showContextMenu(const QPoint& pos);
    void newTab();
    void renameTab();
    void closeTab();
    void tabify();
  signals:
    void newTabRequested(int at);
    void renameTabRequested(int at);
    void closeTabRequested(int at);
    void tabifyRequested(int at);
    void windowMenuRequested(int index, QAction *& m);
  protected:
    void mouseDoubleClickEvent(QMouseEvent * event);
    QSize sizeHint() const;
    void resizeEvent(QResizeEvent * event);
    void tabLayoutChange();
  private:
    void movePlusButton();

    int _currentIndex;
    QToolButton * _plusButton;
  };

} // namespace QGpGuiTools

#endif // MULTIDOCUMENTTABBAR_H
