/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-06-22
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MULTIDOCUMENTSUBWINDOW_H
#define MULTIDOCUMENTSUBWINDOW_H

#include <QtGui>
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
#include <QtWidgets>
#endif

#include <QGpCoreTools.h>

#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

  class MultiDocumentTab;

  class QGPGUITOOLS_EXPORT MultiDocumentSubWindow : public QMdiSubWindow
  {
    Q_OBJECT
  public:
    MultiDocumentSubWindow(QWidget * parent=0, Qt::WindowFlags flags=Qt::WindowFlags());
    ~MultiDocumentSubWindow();

    QAction * windowMenuAction() const {return _windowMenuAction;}
    void setWindowIcon(const QIcon & icon);
    MultiDocumentTab * tab() const;

    void setUserClosable(bool c) {_userClosable=c;}
    bool userClosable() const {return _userClosable;}
  public slots:
    void setWindowTitle(const QString & t);
    void show();
  signals:
    void moveToTabMenuRequested(QMenu * menu, MultiDocumentSubWindow * w);
  private slots:
    void windowsMenuTriggered();
    void moveToTabMenu();
  protected:
    virtual void closeEvent(QCloseEvent * e);
  private:
    QAction * _windowMenuAction;
    bool _userClosable;
  };

} // namespace QGpGuiTools

#endif // MULTIDOCUMENTSUBWINDOW_H
