/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  QGpGuiTools is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiTools is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-05-21
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ITEMDELEGATE_H
#define ITEMDELEGATE_H

#include <QtWidgets>

#include "QGpGuiToolsDLLExport.h"
#include "DoubleSpinBox.h"

namespace QGpGuiTools {

  class QGPGUITOOLS_EXPORT ItemDelegate : public QItemDelegate
  {
    Q_OBJECT
  public:
    ItemDelegate(QObject * parent=nullptr);
    ~ItemDelegate();

    void setEditorData(QWidget *editor, const QModelIndex &index) const;
    void setModelData(QWidget *editor, QAbstractItemModel *model,
                      const QModelIndex &index) const;
  protected:
    QLineEdit * createLineEdit(QWidget * parent) const;
    QComboBox * createComboBox(QWidget * parent) const;
    DoubleSpinBox * createDoubleSpinBox(QWidget * parent) const;
    QSpinBox * createSpinBox(QWidget * parent) const;
  protected slots:
    void commitWidget(QWidget * w=nullptr);
  signals:
    void dataChanged(const QModelIndex &index, StringDiff string) const;
  };

} // namespace QGpGuiTools

#endif // ITEMDELEGATE_H

