/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-09-13
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef FROZENWIDGET_H
#define FROZENWIDGET_H

#include "WidgetRect.h"
#include "Settings.h"
#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

  class QGPGUITOOLS_EXPORT FrozenWidget : public QWidget, public WidgetRect
  {
    Q_OBJECT
  public:
    FrozenWidget(QWidget * parent=nullptr);
    ~FrozenWidget() {}

    void saveRect(QString name) {WidgetRect::saveRect(this, name);}
    void restoreRect(QString name) {Settings::getRect(this, name);}
  protected:
    virtual void resizeEvent(QResizeEvent * e);
    virtual void moveEvent(QMoveEvent * e);
  };

} // namespace QGpGuiTools

#endif // FROZENWIDGET_H

