/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-02-14
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef COLUMNTEXTDELEGATE_H
#define COLUMNTEXTDELEGATE_H

#include <QtGui>
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
#include <QtWidgets>
#endif

#include <QGpCoreTools.h>

#include "QGpGuiToolsDLLExport.h"
#include "ItemDelegate.h"

namespace QGpGuiTools {

  class QGPGUITOOLS_EXPORT ColumnTextDelegate : public ItemDelegate
  {
    Q_OBJECT
  public:
    ColumnTextDelegate(QObject *parent=nullptr) : ItemDelegate(parent) {}

    void setTypes(QStringList t) {_types=t;}
    const QStringList& types() const {return _types;}

    QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &option,
                           const QModelIndex &index) const;
  private:
    QStringList _types;
  };

} // namespace QGpGuiTools

#endif // COLUMNTEXTDELEGATE_H
