/***************************************************************************
**
**  This file is part of QGpGuiStat.
**
**  QGpGuiStat is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiStat is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-11-24
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CATEGORYCHOOSER_H
#define CATEGORYCHOOSER_H

#include <SciFigs.h>
#include <QGpCoreStat.h>

#include "QGpGuiStatDLLExport.h"

namespace Ui {
  class CategoryChooser;
}

namespace QGpGuiStat {

  class QGPGUISTAT_EXPORT CategoryChooser : public QWidget
  {
    Q_OBJECT
  public:
    CategoryChooser(QWidget * parent=0);
    ~CategoryChooser();

    void setCategories(const Legend& cat);
    void updateAllFields();

    SampleClassificationParameters::CategoryCondition type() const;
    int category() const;
  private slots:
    void enableCategoryWidget();
  private:
    Ui::CategoryChooser * _ui;
  };

} // namespace QGpGuiStat

#endif // CATEGORYCHOOSER_H

