/***************************************************************************
**
**  This file is part of QGpGuiMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-01-10
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef IMAGELAYERPROPERTIES_H
#define IMAGELAYERPROPERTIES_H

#include <QGpGuiTools.h>
#include "ui_ImageLayerProperties.h"

namespace Ui {
  class ImageLayerProperties;
}

namespace QGpGuiMath {

  class ImageLayer;
  class ImageScalingPoint;

  class ImageLayerProperties : public PropertyWidget
  {
    Q_OBJECT
  public:
    ImageLayerProperties(QWidget * parent=nullptr);
    ~ImageLayerProperties();

    void addLayer(ImageLayer * layer);
    void removeLayer(ImageLayer * layer);

    enum Properties {XOrigin, YOrigin, XScale, YScale, ImageFile};
  private slots:
    void on_imageBrowse_clicked();
    void on_image_textEdited(const QString& text);
    void on_reference_clicked();
  private:
    bool loadImage(const QString &fileName);

    Ui::ImageLayerProperties * _ui;
    QSet<ImageLayer *> _layerSet;
  };

} // namespace QGpGuiMath

#endif // IMAGELAYERPROPERTIES_H
