/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-08-06
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TILTPATH_H
#define TILTPATH_H

#include <QGpCoreTools.h>

namespace QGpCoreWave {

class TiltPath
{
public:
  double time() const {return _dt;}
  double abscissa(int iLayer) const {return _x[iLayer];}
protected:
  friend class TiltNode;
  TiltPath();

  inline void setOrigin(double x0);
  double origin() const {return _x[0];}

  inline void setDeepestLayer(int toLayer);
  inline void setIntercept(int iLayer, double x, double dt);
private:
  VectorList<double> _x;
  double _dt;
};

inline void TiltPath::setOrigin(double x0)
{
  TRACE;
  _x[0]=x0;
}

inline void TiltPath::setDeepestLayer(int toLayer)
{
  TRACE;
  _x.resize(toLayer+1);
}

inline void TiltPath::setIntercept(int iLayer, double x, double dt)
{
  TRACE;
  _x[iLayer]=x;
  _dt+=dt;
}

} // namespace QGpCoreWave

#endif // TILTPATH_H
