/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-08-23
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef MAGNETOTELLURICPROXY_H
#define MAGNETOTELLURICPROXY_H

#include <QGpCoreMath.h>

#include "MagnetoTelluricPointOptions.h"
#include "MagnetoTelluricCurve.h"
#include "QGpCoreWaveDLLExport.h"

namespace QGpCoreWave {

  class QGPCOREWAVE_EXPORT MagnetoTelluricProxy : public CurveProxy
  {
  public:
    MagnetoTelluricProxy() : CurveProxy() {_curve=0;}

    QString tag() const {return "MagnetoTelluricProxy";}
    CurveProxy * clone() const {return new MagnetoTelluricProxy;}

    CURVEPROXY_BASIC_DECLARATIONS(MagnetoTelluricCurve)
    CURVEPROXY_NAME_DECLARATIONS
    CURVEPROXY_LOG_DECLARATIONS

    double y(int sample, const CurvePointOptions * options) const;
    void setY(int sample, double value, const CurvePointOptions * options);

    double stddev(int sample) const;
    void setStddev(int sample, double value);

    double weight(int sample) const;
    void setWeight(int sample, double value);

    void average(const CurveProxy * o) {
      curve().average(static_cast<const MagnetoTelluricProxy *>(o)->curve());
    }
    void interpole(double x, double& y, double& dy,
                   const CurvePointOptions * options,
                   SamplingOptions xSampling,
                   SamplingOptions ySampling) const;
    void followMaximumX(IrregularGrid2D * grid, double min, double max);

    int columnCount() const {return 10;}
    QString columnName(int col) const;
    QString columnUnit(int col) const;
    QString columnTitle(int col) const;

    QVariant columnValue(int sample, int col) const;
    void setColumnValue(int sample, int col, const QVariant & value);

    int xAxisColumn() const {return 0;}
    int xAxisInverseColumn() const  {return 1;}
    int yAxisColumn() const;
    int yAxisInverseColumn() const {return -1;}

    QStringList columnFileTypes() const;
    VectorList<int> defaultColumnFileTypes() const;
    VectorList<int> savedColumns() const;

    bool parse(ColumnTextIterator& it);

    void setYMode(MagnetoTelluricPointOptions::OutputMode m) {_yMode=m;}
    MagnetoTelluricPointOptions::OutputMode yMode() const {return _yMode;}
  private:
    CURVEPROXY_PRIVATE_DECLARATIONS(MagnetoTelluricCurve, MagnetoTelluricPoint)
    MagnetoTelluricPointOptions::OutputMode _yMode;
  };

} // namespace QGpCoreWave

#endif // MAGNETOTELLURICPROXY_H

