/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-10-22
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MODALELLIPTICITY_H
#define MODALELLIPTICITY_H

#include <QGpCoreTools.h>

#include "QGpCoreWaveDLLExport.h"
#include "ModalStorage.h"
#include "Rayleigh.h"

namespace QGpCoreWave {

class Dispersion;

class QGPCOREWAVE_EXPORT Ellipticity :  public ModalStorage
{
  TRANSLATIONS("EllipticityFactory")
public:
  Ellipticity(int nModes, const VectorList<double>* x) : ModalStorage(nModes, x) {}

  QList<double> peaks(int modeIndex, Dispersion& disp, Rayleigh * waveModel);
  double peakMisfit(int modeIndex, const RealStatisticalValue& val, double minAbsEll,
                    Dispersion& disp, Rayleigh * waveModel);

  void addLove(double alpha);
  void toStream(QTextStream& s, int modeIndex, const QString& comments=QString(),
                double signThreshold=std::numeric_limits<double>::infinity()) const;
private:
  inline double refineMax(int modeIndex, int iOmega, Dispersion& disp,
                           RootSolver<Rayleigh>& , bool& badSampling);
};

} // namespace QGpCoreWave

#endif // ELLIPTICITY_H
