/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  QGpCoreTools is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreTools is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-02-18
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef PARALLELTASKWORKER_H
#define PARALLELTASKWORKER_H

#include "ParallelLoop.h"

#include "QGpCoreToolsDLLExport.h"

namespace QGpCoreTools {

  class ParallelTaskManager;
  class ParallelTask;

  class QGPCORETOOLS_EXPORT ParallelTaskWorker : public LoopWorker
  {
  public:
    ParallelTaskWorker();
    ~ParallelTaskWorker();

    void setTaskManager(ParallelTaskManager * tm) {_taskManager=tm;}
  protected:
    ParallelTaskManager * taskManager() const {return _taskManager;}

    virtual void run(int);
    virtual void process(ParallelTask * t)=0;
    virtual void polish(ParallelTask * /*t*/) {}
    virtual void mergeResults() {}
  private:
    ParallelTaskManager * _taskManager;
  };

} // namespace QGpCoreTools

#endif // PARALLELTASKWORKER_H

