/***************************************************************************
**
**  This file is part of QGpCoreTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-02-08
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/


#include "PackageInfo.h"
#include "Trace.h"

namespace QGpCoreTools {

QList<PackageInfo> * PackageInfo::_list=0;

/*!
  \class PackageInfo PackageInfo.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
PackageInfo::PackageInfo(QString package,
                         QString binDir,
                         QString libDir,
                         QString includeDir,
                         QString shareDir,
                         QString version,
                         QString versionType,
                         QString gitCommit,
                         QString distribution,
                         QString authors)
{
  _package=package;
  _binDir=binDir;
  _libDir=libDir;
  _includeDir=includeDir;
  _shareDir=shareDir;
  _version=version;
  _versionType=versionType;
  _gitCommit=gitCommit;
  _distribution=distribution;
  _authors=authors;
}

/*!
  Called by application object

  Use of QSettings in the early times of the application (before QApplication) forces
  the current thread to be Qt main thread. Ennoying to Python modules which are running
  QApplication and its loop in "secondary" thread.
  Postpone this search after the creation of the application.

*/
void PackageInfo::setInstallDirs()
{
  QString org=QCoreApplication::organizationName();
  _binDir=getInstallDir(org, "binDir", _binDir);
  _libDir=getInstallDir(org, "libDir", _libDir);
  _includeDir=getInstallDir(org, "includeDir", _includeDir);
  _shareDir=getInstallDir(org, "shareDir", _shareDir);
}

QString PackageInfo::getInstallDir(QString organization, QString dir, QString defaultDir)
{
  QSettings reg(organization, _package);
  reg.beginGroup("installpaths");
  if(reg.contains(dir)) {
    return reg.value(dir).toString();
  } else {
    return defaultDir;
  }
}

QList<PackageInfo> * PackageInfo::list()
{
  if(!_list) _list=new QList<PackageInfo>;
  return _list;
}

const PackageInfo * PackageInfo::package(QString package)
{
  for(QList<PackageInfo>::iterator it=PackageInfo::_list->begin();it!=PackageInfo::_list->end(); it++ ) {
    if(package==it->package()) {
      return &(*it);
    }
  }
  return 0;
}


} // namespace QGpCoreTools
