/***************************************************************************
**
**  This file is part of QGpCoreStat.
**
**  QGpCoreStat is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreStat is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-08-24
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef GAUSSIANMIXTUREPARAMETERS_H
#define GAUSSIANMIXTUREPARAMETERS_H

#include <QGpCoreTools.h>

#include "QGpCoreStatDLLExport.h"

namespace QGpCoreStat {

  class QGPCORESTAT_EXPORT GaussianMixtureParameters : public AbstractParameters
  {
  public:
    GaussianMixtureParameters();
    ~GaussianMixtureParameters();

    AbstractParameters * clone() const;

    int modeCount() const {return _modeCount;}
    void setModeCount(int m) {_modeCount=m;}

    double meanSpacingFactor() const {return _meanSpacingFactor;}
    void setMeanSpacingFactor(double f) {_meanSpacingFactor=f;}

    int maximumModeCount(double min, double max) const;

    bool verbose() const {return _verbose;}
    void setVerbose(bool v) {_verbose=v;}

    double kmin() const {return _kmin;}
    void setKmin(double k) {_kmin=k;}

    double kmax() const {return _kmax;}
    void setKmax(double k) {_kmax=k;}
  public:
    int _modeCount;
    double _meanSpacingFactor ;
    bool _verbose;
    double _kmin, _kmax;
  };

} // namespace QGpCoreStat

#endif // GAUSSIANMIXTUREPARAMETERS_H


