/***************************************************************************
**
**  This file is part of QGpCoreStat.
**
**  QGpCoreStat is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreStat is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2017-06-11
**  Copyright: 2017-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef GAUSSIANMIXTURELIKELIHOOD_H
#define GAUSSIANMIXTURELIKELIHOOD_H

#include <DinverCore.h>

#include "QGpCoreStatDLLExport.h"
#include "GaussianMixtureParameters.h"
#include "GaussianMixtureDistribution.h"
#include "MultivariateHistogram.h"

namespace QGpCoreStat {

  class QGPCORESTAT_EXPORT GaussianMixtureLikelihood
      : public AbstractForward
  {
  public:
    GaussianMixtureLikelihood(const GaussianMixtureParameters * p,
                              int dimensionCount);
    GaussianMixtureLikelihood(const GaussianMixtureLikelihood& o);
    ~GaussianMixtureLikelihood();

    void setHistogram(const MultivariateHistogram * h) {_histogram=h;}
    bool setInversionParameters();

    AbstractForward * clone() const;
    double misfit(bool& ok);
    int maximumThreadCount() const {return INT_MAX;}

    void setValues(const int * values);
    const GaussianMixtureDistribution& distribution() const {return *_distribution;}
  private:
    void parametersToModes();
    void parametersToWeights(int firstWeightIndex);
    void setWeightParameters();

    int _dimensionCount;
    const GaussianMixtureParameters * _parameters;
    const MultivariateHistogram * _histogram;
    GaussianMixtureDistribution * _distribution;
  };

} // namespace QGpCoreStat

#endif // GAUSSIANMIXTURELIKELIHOOD_H

