/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-09-24
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "Vector.h"

namespace QGpCoreMath {

  /*!
    \class Vector Vector.h
    \brief A light vector with fixed dimension.

    The vector does not own its values but just operate on them.
    Use PrivateVector if you do not want to handle memory allocation
  */

  /*!
    \fn void Vector<T>::setValue(const T& value)

    Assigns the same \a value to all elements of the vector.
  */

  /*!
    \fn void Vector<T>::setValues(T * values)

    Use this function carefully. This is not a virtual function and it can be re-implemented
    like in PrivateVector.
  */

  /*!
    \fn void Vector<T>::setValues(const Vector<T>& o)

    Use this function carefully. This is not a virtual function and it can be re-implemented
    like in PrivateVector.
  */

  /*!
    \fn T * Vector<T>::values()

    Returns the values as a C vector.

    Use this function carefully. Classes that inherit Vector<T> may delete their values
    themselves like in PrivateVector.
  */

  /*!
    \fn const T * Vector<T>::values() const

    Returns the values as a C vector.
  */

  /*!
    \fn double Vector<T>::length() const

    Returns the length of the vector. It is available only for types that can be converted
    to double.
  */

  /*!
    \fn double Vector<T>::length(int axis1, int axis2) const

    Returns the length of the vector in the plane formed by \a axis1 and \a axis2.
   It is available only for types that can be converted to double.
  */

  /*!
    \fn double Vector<T>::azimuth(int axis1, int axis2) const

    Returns the azimuth of the vector in the plane formed by \a axis1 and \a axis2.
    It is available only for types that can be converted to double.
  */

/*!
  \fn double Vector<T>::scalarProduct(const Vector<T>& o) const

  Returns the scalar product between this and \a o.
  It is available only for types that can be converted to double.
*/

/*!
  \fn double Vector<T>::scalarProduct(const Point2D& o) const

  Returns the scalar product between this and \a o.
  It is available only for types that can be converted to double and at least 2-element vectors.
*/

/*!
  \fn Complex Vector<T>::scalarProductConjugate(const Vector<T>& o) const

  Returns the scalar product between this and the conjugate of \a o.
  It is available only for types that can be converted to Complex.
*/

  /*!
    \fn void Vector<T>::multiply(const Matrix<T>& m, const Vector<T>& v)

    Multiplies matrix \a m with column vector \a v. The result is a column vector stored in this.
  */

  /*!
    \fn void Vector<T>::multiply(const Vector<T>& v, const Matrix<T>& m)

    Multiplies row vector \a v with matrix \a m . The result is a row vector stored in this.
  */

  /*!
    \fn void Vector<T>::operator<(const Vector<T>& o)

    Returns true if at least one component of this vector is less than the
    corresponding component of vector \a o.
  */

  /*!
    \fn void Vector<T>::operator>(const Vector<T>& o)

    Returns true if at least one component of this vector is greater than the
    corresponding component of vector \a o.
  */

  /*!
    \fn void Vector<T>::resize(int count)

    Resize the vector to \a count. It is a protected function because it cannot be
    used by a strictly Vector object which does not own its values.

    \sa PrivateVector
  */

  /*!
    Converts a Vector into a VectorList.
    Used only for debug inside QtCreator.
  */
  VectorList<double> qVector(const Vector<double>& v)
  {
    VectorList<double> qv(v.count());
    for(int i=v.count()-1; i>=0; i--) {
      qv[i]=v[i];
    }
    return qv;
  }

} // namespace QGpCoreMath

