/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-01-12
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SPHERE_H
#define SPHERE_H

#include "Point.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT Sphere
  {
  public:
    Sphere(double x0=0.0, double y0=0.0, double z0=0.0, double r=0.0);
    Sphere(const Point& c, double r);
    Sphere(const Sphere& o);

    const Point& center() const {return _c;}
    double radius() const {return _r;}

    double distanceTo(const Point& p) const;
    bool contains(const Point& p) const;
  private:
    Point _c;
    double _r;
  };

} // namespace QGpCoreMath

#endif // SPHERE_H

