/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-08-23
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef REALSTATISTICALPROXY_H
#define REALSTATISTICALPROXY_H

#include "CurveProxy.h"
#include "RealStatisticalCurve.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT RealStatisticalProxy : public CurveProxy
  {
    TRANSLATIONS("RealStatisticalProxy")
  public:
    RealStatisticalProxy() : CurveProxy() {_curve=nullptr; _split=nullptr;}
    ~RealStatisticalProxy() {delete _split;}

    QString tag() const {return "RealStatisticalProxy";}

    CurveProxy * clone() const {return new RealStatisticalProxy;}

    CURVEPROXY_BASIC_DECLARATIONS(RealStatisticalCurve)
    CURVEPROXY_ADVANCED_DECLARATIONS(RealStatisticalProxy)
    CURVEPROXY_NAME_DECLARATIONS
    CURVEPROXY_LOG_DECLARATIONS

    int columnCount() const {return 4;}
    QString columnName(int col) const;
    QString columnUnit(int col) const;

    QVariant columnValue(int sample, int col) const;
    void setColumnValue(int sample, int col, const QVariant & value);

    int xAxisColumn() const {return 0;}
    int xAxisInverseColumn() const  {return -1;}
    int yAxisColumn() const {return 1;}
    int yAxisInverseColumn() const {return -1;}

    QStringList columnFileTypes() const;
    VectorList<int> defaultColumnFileTypes() const;
    VectorList<int> savedColumns() const;

    bool parse(ColumnTextIterator& it);
  private:
    CURVEPROXY_PRIVATE_DECLARATIONS(RealStatisticalCurve, RealStatisticalPoint)
  };

} // namespace QGpCoreMath

#endif // REALSTATISTICALPROXY_H

