/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-06-18
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef GRIDSEARCH3D_H
#define GRIDSEARCH3D_H

#include "FunctionSearch.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT GridSearch3D : public FunctionSearch
  {
  public:
    GridSearch3D();
    ~GridSearch3D();

    void setGrid(double stepXY, double sizeXY, double stepZ, double sizeZ);
    void setGrid(double minX, double maxX, double stepX,
                 double minY, double maxY, double stepY,
                 double minZ, double maxZ, double stepZ);

    void globalMax(double absThres=0.0);
    void localMax(int nMax, double absThres=0.0, double relThres=0.0);

    static void showProcessingTime();
  protected:
    double refineMax(double val);

    PrivateVector<int> _min, _max;
    PrivateVector<double> _step;
#ifdef COMPATIBILITY_3_4_1
    double _minXY;
#endif
  private:
    inline void setCurrentPosition(int ix, int iy, int iz);
    inline double maximumValueZ(Vector<int>& index);
  };

} // namespace QGpCoreMath

#endif // GRIDSEARCH3D_H

