/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-07-15
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GAUSSIANFREQUENCYBAND_H
#define GAUSSIANFREQUENCYBAND_H

#include "FrequencyBand.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT GaussianFrequencyBand
  {
  public:
    GaussianFrequencyBand();
    GaussianFrequencyBand(const GaussianFrequencyBand& o) {operator=(o);}
    ~GaussianFrequencyBand();

    void operator=(const GaussianFrequencyBand& o);

    void calculate(const FrequencyBand& f, double windowLength, double samplingFrequency);
    void sqrt();
    int minimumIndex() const {return _iFreqMin;}
    int maximumIndex() const {return _iFreqMax;}
    double taperValue(int i) const {return _gaussianPtr[i];}
  private:
    int _iFreqMin, _iFreqMax;
    double * _gaussian;
    double * _gaussianPtr;
  };

} // namespace QGpCoreMath

#endif // GAUSSIANFREQUENCYBAND_H
