/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2022-03-03
**  Copyright: 2022
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef FUNCTIONPLOT_H
#define FUNCTIONPLOT_H

#include "QGpCoreMathDLLExport.h"

#include "AbstractFunction.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT FunctionPlot
  {
  public:
    FunctionPlot(int xSize, AbstractFunction * f=nullptr);
    virtual ~FunctionPlot();

    void setFunction(AbstractFunction * f);
    AbstractFunction * takeFunction();
    AbstractFunction * function() const {return _function;}

    virtual double value(double x, double y) const;
  protected:
    mutable PrivateVector<double> _x;
  private:
    AbstractFunction * _function;
  };

} // namespace QGpCoreMath

#endif // FUNCTIONPLOT_H

