/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-11-12
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "FrequencyBand.h"

namespace QGpCoreMath {

  /*!
    \class FrequencyBand FrequencyBand.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  FrequencyBand::FrequencyBand()
    : AbstractParameters()
  {
    _center=0.0;
    _relativeWidth=0.0;
    _omega=0.0;
    _squaredOmega=0.0;
  }

  FrequencyBand::FrequencyBand(const FrequencyBand& o)
    : AbstractParameters(o)
  {
    _center=o._center;
    _relativeWidth=o._relativeWidth;
    _omega=o._omega;
    _squaredOmega=o._squaredOmega;
  }

} // namespace QGpCoreMath
