/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2012-11-27
**  Copyright: 2012-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ELLIPSE_H
#define ELLIPSE_H

#include "QGpCoreMathDLLExport.h"
#include "Point2D.h"
#include "Angle.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT Ellipse
  {
  public:
    Ellipse();
    Ellipse(const Point2D& c, double rmaj, double rmin=0.0, double orientation=0.0);

    const Point2D& center() const {return _center;}
    void setCenter(const Point2D& c) {_center=c;}

    double majorRadius() const {return _majorRadius;}
    void setMajorRadius(double r) {_majorRadius=fabs(r);}

    double minorRadius() const {return _minorRadius;}
    void setMinorRadius(double r) {_minorRadius=fabs(r);}

    double xRadius() const;
    double yRadius() const;

    const Angle& orientation() const {return _orientation;}
    void setOrientation(double o);

    QString toString() const;
  private:
    Point2D _center;
    double _majorRadius;
    double _minorRadius;
    Angle _orientation;
  };

} // namespace QGpCoreMath
#endif // ELLIPSE_H
