/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-03-31
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CURVEPROPERTIES_H
#define CURVEPROPERTIES_H

#include <QtCore>

#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT CurveProperties
  {
  public:
    inline bool operator==(const CurveProperties& o) const;

    void setName(const QString & n) {_name=n;}
    QString name() const {return _name;}

    void addLog(QString s) {_log+=s;}
    const QString& log() const {return _log;}
    void clearLog() {_log.clear();}
  private:
    QString _name;
    QString _log;
  };

  inline bool CurveProperties::operator==(const CurveProperties& o) const
  {
    return _name==o._name &&
           _log==o._log;
  }

} // namespace QGpCoreMath

#endif // CURVEPROPERTIES_H

