/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-08-23
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef COMPLEXSTATISTICALPROXY_H
#define COMPLEXSTATISTICALPROXY_H

#include "BasicCurveProxy.h"
#include "StatisticalPoint.h"
#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT ComplexStatisticalProxy : public BasicCurveProxy
  {
    TRANSLATIONS("ComplexStatisticalProxy")
  public:
    ComplexStatisticalProxy() : BasicCurveProxy() {_curve=0;}

    QString tag() const {return "ComplexStatisticalProxy";}

    CurveProxy * clone() const {return new ComplexStatisticalProxy;}

    CURVEPROXY_BASIC_DECLARATIONS(Curve<ComplexStatisticalPoint>)

    double y(int sample, const CurvePointOptions * options) const;
    void setY(int sample, double value, const CurvePointOptions * options);

    double stddev(int sample) const;
    void setStddev(int sample, double value);

    double weight(int sample) const;
    void setWeight(int sample, double value);

    void average(const CurveProxy * o) {
      curve().average(static_cast<const ComplexStatisticalProxy *>(o)->curve());
    }
    void interpole(double x, double& y, double& dy,
                   const CurvePointOptions * options,
                   SamplingOptions xSampling,
                   SamplingOptions ySampling) const;
    void followMaximumX(IrregularGrid2D * grid, double min, double max);

    int columnCount() const {return 4;}
    QString columnName(int col) const;
    QString columnUnit(int col) const;

    QVariant columnValue(int sample, int col) const;
    void setColumnValue(int sample, int col, const QVariant & value);

    int xAxisColumn() const {return 0;}
    int xAxisInverseColumn() const  {return -1;}
    int yAxisColumn() const {return 1;}
    int yAxisInverseColumn() const {return -1;}

    QStringList columnFileTypes() const;
    VectorList<int> defaultColumnFileTypes() const;
    VectorList<int> savedColumns() const;

    bool parse(ColumnTextIterator& it);
  private:
    CURVEPROXY_PRIVATE_DECLARATIONS(Curve<ComplexStatisticalPoint>, ComplexStatisticalPoint)
  };

} // namespace QGpCoreMath

#endif // COMPLEXSTATISTICALPROXY_H

