/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-11-15
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTCOLORPALETTE_H
#define ABSTRACTCOLORPALETTE_H

#include "QGpCoreMathDLLExport.h"
#include "ColorPalette.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT AbstractColorPalette
  {
  public:
    AbstractColorPalette() {}
    virtual ~AbstractColorPalette() {}

    virtual void generate(int imin, int imax, const QString& model=ColorPalette::defaultSequential,
                          ColorPalette::Options options=ColorPalette::Continuous,
                          quint16 transparency=COLOR_COMPONENT_MAX)=0;
    virtual void toGray()=0;
    virtual void rgbInterpole(int imin, int imax);
    virtual void hsvInterpole(int imin, int imax);

    virtual ColorPalette palette() const=0;
    virtual void setPalette(const ColorPalette& pal)=0;

    virtual int count() const=0;
  };

} // namespace QGpCoreMath

#endif // ABSTRACTCOLORPALETTE_H

