/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-01-27
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef STATIONLINE_H
#define STATIONLINE_H

#include <SciFigs.h>

#include "HVGuiDLLExport.h"
#include "CurveResults.h"

namespace HVGui {

class HVGUI_EXPORT StationLine : public AbstractNameLine
{
public:
  StationLine() {_station=nullptr;}
  StationLine(const StationLine& o);

  AbstractLine * clone() const;
  void operator=(const AbstractLine& o);
  bool canCopy(const AbstractLine& o) const;

  const QString& xml_tagName() const {return NameLine::xmlNameLineTag;}

  int count() const {return _station ? 1 : 0;}
  bool isSorted() const {return false;}
  Point point(int, const CurvePointOptions *) const {return _station->coordinates();}
  QString name(int) const;

  void clear() {}
  void append() {}
  void insert(int) {}
  void removeLast() {}
  void setX(int, double) {}
  void setY(int, double, const CurvePointOptions *) {}
  void setZ(int, double, const CurvePointOptions *) {}
  void setName(int, QString) {}

  enum Label {StationName, PeakValue, NoLabel};
  enum PeakSelection {PeakNumber, PeakLowest, PeakHighest, PeakMaximum};

  void setStation(CurveResults * station) {_station=station;}
  void setLabel(Label l) {_label=l;}
  void setLabelPrecision(int p) {_labelPrecision=p;}
  void setValue(PeakSelection ps, CurveResults::PeakValue pv, int peakIndex);
  const RealValue& value() const {return _value;}
protected:
  Label _label;
  int _labelPrecision;
  RealValue _value;
  CurveResults * _station;
};

} // namespace HVGui

#endif // STATIONLINE_H
