/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-10
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LOADWINSTATLIST_H
#define LOADWINSTATLIST_H

#include <QGpGuiTools.h>
#include <HVCore.h>

#include "ui_LoadWinStatList.h"
#include "HVGuiDLLExport.h"

namespace HVGui {

  class HVGUI_EXPORT LoadWinStatList : public Dialog, public Ui::LoadWinStatList
  {
    Q_OBJECT
  public:
    LoadWinStatList(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::Widget);
  public slots:
    void setStationsList(QList<AbstractStation *> list);
    void getSelectedStations(QList<AbstractStation *> list, QList<AbstractStation *>& selList);
  };

} // namespace HVGui

#endif // LOADWINSTATLIST_H
