/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2003-12-08
**  Copyright: 2003-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTRESULTSHEET_H
#define ABSTRACTRESULTSHEET_H

#include <SciFigs.h>
#include <HVCore.h>

#include "AbstractResultWidget.h"
#include "HVGuiDLLExport.h"

namespace HVGui {

  class HVGUI_EXPORT AbstractResultSheet : public GraphicSheetMenu
  {
    Q_OBJECT
  public:
    AbstractResultSheet(QWidget * parent=nullptr);

    virtual void setWindowTitle(QString subPoolName)=0;
    virtual void addActions();
    virtual void setStations(const QList<AbstractStation *>& stations);
    virtual void setLimits(double maxAmplitude)=0;
    void showValues();
    void setParameters(const HVParameters& param) {_parameters=param;}

    virtual void setValueTitle(const QString& t);
    const QString& valueTitle() const {return _valueTitle;}
    void setUnits(const QString& title);

    void restoreMakeUp(QString fileName);
    virtual void setLayout(int nPlotsPerLine, double pageHeight);

    QMenu * menuTools;
    QAction * saveResultsAction;

    int stationCount() const {return _stations.count();}
    AbstractStation * station(int index) const {return _stations.at(index);}
    int indexOf(AbstractStation * c) {return _stations.indexOf(c);}
    AbstractStation * station(const QString& name) const;
    QList<AbstractStation *> selectedStations() const;
    QList<AbstractResultWidget *> selectedResults() const;
    QList<AbstractResults *> results() const;
  protected slots:
    void saveResults();
    void setCategories();
    void categoriesToGroups();
    void groupsToCategories();
  signals:
    void resultsChanged();
  protected:
    virtual QString fileSuffix()=0;
    virtual AbstractResultWidget * createWidget()=0;
    const AbstractResults * firstValidResult() const;
    AbstractResultWidget * addWidget();
    void save(const AbstractResults * res, QDir outputDir, bool askIndividualFileName);
    bool selectAll(QString title);
    SignalDatabase * database() const;

    QList<AbstractStation *> _stations;
    QList<AbstractResultWidget *> _results;
  private:
    QString _valueTitle;
    HVParameters _parameters;
  };

} // namespace HVGui

#endif // ABSTRACTRESULTSHEET_H
