/***************************************************************************
**
**  This file is part of HVCore.
**
**  HVCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-02-18
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HVTASKMANAGER_H
#define HVTASKMANAGER_H

#include <QGpCoreTools.h>

#include "HVCoreDLLExport.h"

namespace HVCore {

  class HVParameters;
  class AbstractStation;

  class HVCORE_EXPORT HVTaskManager : public ParallelTaskManager
  {
  public:
    HVTaskManager(const QList<AbstractStation *>& stations);
    ~HVTaskManager();

    bool setParameters(const HVParameters * p);
    const HVParameters * parameters() const {return _parameters;}

    AbstractStation * station(int index) {return _stations.at(index);}
    void setTasks();
  protected:
    LoopWorker * newWorker();
    ParallelTask * createTask(int taskIndex);

    const HVParameters * _parameters;
    QList<AbstractStation *> _stations;
  };

} // namespace HVCore

#endif // HVTASKMANAGER_H

