/***************************************************************************
**
**  This file is part of HVCore.
**
**  HVCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-02-18
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "HVTask.h"
#include "HVTaskManager.h"
#include "HVParameters.h"
#include "AbstractStation.h"
#include "AbstractResults.h"

namespace HVCore {

  /*!
    \class HVTask HVTask.h
    \brief Brief description of class still missing

    A task is in charge of computing one station (exclusively)
  */

  /*!
    Description of constructor still missing
  */
  HVTask::HVTask(HVTaskManager * manager,
                 int taskIndex,
                 AbstractStation * station)
    : ParallelTask(manager, taskIndex)
  {
    TRACE;
    _station=station;
  }

  /*!
    Description of destructor still missing
  */
  HVTask::~HVTask()
  {
    TRACE;
  }

  inline const HVTaskManager * HVTask::taskManager() const
  {
    TRACE;
    return static_cast<HVTaskManager *>(parent());
  }

  void HVTask::init()
  {
    const HVParameters * param=taskManager()->parameters();
    _station->clearResults();
    _station->initResults(_station->windowCount(), *param);
    _station->setHighPassFilter(param->highPassFrequency());
    setStepCount(_station->windowCount());
    QString status=tr("%1: %2 windows")
        .arg(_station->name())
        .arg(_station->windowCount());
    App::log(status+"\n");
    emit statusChanged(taskIndex(), status);
    ParallelTask::init();
  }

} // namespace HVCore

