/***************************************************************************
**
**  This file is part of HVCore.
**
**  HVCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-02-20
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HVSTATION_H
#define HVSTATION_H

#include "AbstractStation.h"
#include "CurveResults.h"
#include "HVCoreDLLExport.h"

namespace HVCore {

  class HVStationSignals;
  class FrequencyWindowRejection;

  class HVCORE_EXPORT HVStation : public AbstractStation
  {
  public:
    HVStation(StationSignals * sig);

    QString name() const {return _signals->originalSignals()->name();}
    QString name(int) const {return name();}

    StationProcessSignals * createProcessSignals();
    void process(StationProcessSignals * proc, int windowIndex, const HVParameters * param) const;
    bool save(int, QDir outputDir, const HVParameters& param);

    bool frequencyWindowRejection(const FrequencyWindowRejection& param);
  protected:
    AbstractResults * createResults();
  };

} // namespace HVCore

#endif // HVSTATION_H
