/***************************************************************************
**
**  This file is part of GeopsyPySciFigs.
**
**  GeopsyPySciFigs is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyPySciFigs is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-12-18
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef METHODARGUMENT_H
#define METHODARGUMENT_H

#include "PythonNumPy.h"
#include <SciFigs.h>

#define MAXIMUM_ARGUMENT_COUNT 5

class MethodArgument
{
public:
  MethodArgument() {_object.qObject=nullptr;}

  static void initTypes();
  static bool isSupported(int type);

#if(QT_VERSION>=QT_VERSION_CHECK(6, 5, 0))
  bool setArgument(PyObject * args, int index, const QMetaType& type);
  bool setReturnArgument(const QMetaType& type);
  static QVariant toVariant(PyObject * args, int index, const QMetaType& type);
#else
  bool setArgument(PyObject * args, int index, int typeId);
  bool setReturnArgument(int typeId);
  static QVariant toVariant(PyObject * args, int index, int typeId);
#endif
  PyObject * toPyObject() const;

  static int checkCount(PyObject * args, int expectedCount);
  static int maximumArgumentCount() {return MAXIMUM_ARGUMENT_COUNT;}

#if(QT_VERSION>=QT_VERSION_CHECK(6, 5, 0))
  const QMetaMethodArgument& argument() {return _argument;}
  QMetaMethodReturnArgument& returnArgument() {return _returnArgument;}
#else
  const QGenericArgument& argument() {return _argument;}
  QGenericReturnArgument& returnArgument() {return _returnArgument;}
#endif
  bool hasReturnArgument() const {return _type!=QMetaType::Void;}
  void registerObject();

private:
  bool unsupportedTypeError() const;
  static bool toBool(PyObject * arg, bool& ok, int index);
  static int toInt(PyObject * arg, bool& ok, int index);
  static double toDouble(PyObject * arg, bool& ok, int index);
  static QString toString(PyObject * arg, bool& ok, int index);
  static QObject * toObjectStar(PyObject * arg);

  static QMap<int, int> _customTypes;

  int _type;
  bool _booleanFlag;
  int _integerValue;
  double _floatValue;
  QString _string;
  union {
    QObject * qObject;
    AxisWindow * axisWindow;
    Axis * axis;
    GraphContents * graphContents;
    GraphContentsLayer * graphContentsLayer;
    GraphicObject * graphicObject;
    TextEdit * textEdit;
    LegendWidget * legendWidget;
    ColorMapWidget * colorMapWidget;
    ImageWidget * imageWidget;
  } _object;
  const char * _objectClassName;
  int _objectId;

#if(QT_VERSION>=QT_VERSION_CHECK(6, 5, 0))
  QMetaMethodArgument _argument;
  QMetaMethodReturnArgument _returnArgument;
#else
  QGenericArgument _argument;
  QGenericReturnArgument _returnArgument;
#endif
};

#endif // METHODARGUMENT_H

