/***************************************************************************
**
**  This file is part of GeopsyPyCoreWave.
**
**  GeopsyPyCoreWave is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyPyCoreWave is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2023-11-16
**  Copyright: 2023
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef PYTHONARGUMENTS_H
#define PYTHONARGUMENTS_H

#include <QGpCoreWave.h>

class PythonArguments
{
public:
  PythonArguments();
  ~PythonArguments();

  bool parseRayleighDispersion(PyObject * args);
  bool parseRayleighEllipticity(PyObject * args);
  bool parseLove(PyObject * args);

  int nLayers() const;
  int nModes() const {return _nModes;}
  int group() const {return _group;}
  int nSamples() const;

  double * hData() const {return (double *)PyArray_DATA(_h);}
  double * vpData() const {return (double *)PyArray_DATA(_vp);}
  double * vsData() const {return (double *)PyArray_DATA(_vs);}
  double * rhoData() const {return (double *)PyArray_DATA(_rho);}
  VectorList<double> omegaList() const;
  void setValues(ModalStorage& storage);
  PyArrayObject * values() const {return _values;}
private:
  PyArrayObject * toVectorArray(PyObject * obj, const QString& arrayName);
  bool checkLayerNumber() const;
  bool checkLayerNumber(PyArrayObject * array, int nLayers, const QString& arrayName) const;

  PyArrayObject * _h, * _vp, * _vs, * _rho;
  PyArrayObject * _omega, * _values;
  int _nModes, _group;

};

#endif // PYTHONARGUMENTS_H

