/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-08-04
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "TimeReference.h"

namespace GeopsyGui {

TimeReference::TimeReference(QWidget * parent)
    : Dialog(parent)
{
  TRACE;
  setupUi(this);
}

void TimeReference::setTrueTimeDate(double t0, QDateTime ref)
{
  TRACE;
  _t0=t0;
  trueDateTime->setDateTime(ref);
  on_refDateTime_dateTimeChanged(QDateTime());
}

void TimeReference::on_refDateTime_dateTimeChanged(QDateTime)
{
  TRACE;
  // Get trueDateTime
  if(trueDateTime->dateTime().isValid() && refDateTime->dateTime().isValid()) {
    t0Text->setText(QString::number(_t0 +  refDateTime->dateTime().secsTo(trueDateTime->dateTime()) ));
  } else t0Text->setText( "###" );
}

double TimeReference::t0() const
{
  TRACE;
  return _t0 + refDateTime->dateTime().secsTo(trueDateTime->dateTime());
}

QDateTime TimeReference::reference() const
{
  TRACE;
  return refDateTime->dateTime();
}

} // namespace GeopsyGui
