/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  GeopsyGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-05-17
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef TIMEPICKER_H
#define TIMEPICKER_H

#include <SciFigs.h>

#include "GeopsyGuiDLLExport.h"
#include "AbstractGraphicWindow.h"

namespace GeopsyGui {

  class GEOPSYGUI_EXPORT TimePicker : public LayerPicker
  {
    Q_OBJECT
  public:
    TimePicker(QToolButton * parent);
    ~TimePicker();

  protected:
    void pick(GraphContentsLayer * layer, const QPointF& pos);
    void finish();
  signals:
    void picked(const QString& time);
  };

} // namespace GeopsyGui

#endif // TIMEPICKER_H

