/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  GeopsyGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2021-05-17
**  Copyright: 2021
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <QGpGuiTools.h>

#include "TimePicker.h"
#include "GeopsyGuiEngine.h"
#include "SignalLayer.h"

namespace GeopsyGui {

  /*!
    \class TimePicker TimePicker.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  TimePicker::TimePicker(QToolButton * parent)
    : LayerPicker(parent)
  {
    TRACE;

    if(!MultiDocumentEnvironment::instance()) {
      Message::warning(MSG_ID, tr("Time picking"),
                       tr("No multi-document environment available to pick a time."));
      deleteLater();
    }

    QList<MultiDocumentSubWindow *> windows=MultiDocumentEnvironment::instance()->currentTab()->subWindowList();
    for(int i=0; i<windows.count(); ++i) {
      AbstractGraphicWindow * w=qobject_cast<AbstractGraphicWindow *>(windows.at(i)->widget());
      if(w) {
        SignalLayer * sig=w->signalLayer();
        switch(sig->graph()->xAxis()->scaleType()) {
        case Scale::RelativeTime:
        case Scale::AbsoluteTime:
          addLayer(sig);
          break;
        default:
          break;
        }
      }
    }

    if(layers().isEmpty()) {
      Message::warning(MSG_ID, tr("Time picking"),
                       tr("No graphic window available in the current tab to pick a time."));
      deleteLater();
    }

    parent->setChecked(true);
    GeopsyGuiEngine::instance()->showMessage(GeopsyGuiEngine::instance()->database(parent),
                                             tr("Pick time from any open graphic window. "
                                                "Press 'ESC' or click anywhere outside graphic windows to abort. "
                                                "Zoom and browse with the wheel button and key modifiers (SHIFT, CTRL and ALT)."));

    begin(parent->window(), QCursor(QPixmap(":timepickcursor.png"), 4 , 4));
  }

  /*!
    Description of destructor still missing
  */
  TimePicker::~TimePicker()
  {
    TRACE;
  }

  void TimePicker::pick(GraphContentsLayer * layer, const QPointF& pos)
  {
    SignalLayer * sig=static_cast<SignalLayer *>(layer);
    DateTime t;
    if(sig->subPool()->isEmpty()) {
      t=sig->graph()->xAxis()->timeReference();
    } else {
      double d;
      t=sig->timeReference(sig->subPool()->at(sig->signalAt(pos.y(), d)));
    }
    t.addSeconds(layer->graphContents()->options().xs2r(pos.x()));
    emit picked(t.toString(DateTime::defaultUserFormat));
  }

  void TimePicker::finish()
  {
    QToolButton * button=static_cast<QToolButton *>(parent());
    button->setChecked(false);
    end(button->window());
    GeopsyGuiEngine::instance()->showMessage(GeopsyGuiEngine::instance()->database(button),
                                             QString());
    deleteLater();
  }

} // namespace GeopsyGui

